@extends('layouts.admin.app')

@section('title',translate('Terms and Conditions'))

@push('css_or_js')
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
@endpush

@section('content')
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header_ pb-4">
            <div class="row align-items-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <h1 class="page-header-title">{{translate('messages.terms_and_condition')}}</h1>
                </div>
            </div>
        </div>
        <!-- End Page Header -->
        <div class="row gx-2 gx-lg-3">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <form action="{{route('admin.business-settings.terms-and-conditions')}}" method="post" id="tnc-form">
                    @csrf
                    <div class="form-group">
                        <div id="editor" class="min-height-15rem">{!! $tnc['value'] !!}</div>
                        <textarea name="tnc" class="initial-hidden" id="hiddenArea"></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">{{translate('messages.submit')}}</button>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('script_2')
    <script src="{{dynamicAsset('public/assets/admin/js/quill.js')}}"></script>

    <!-- Initialize Quill editor -->
    <script>
        "use strict";
        let quill = new Quill('#editor', {
            theme: 'snow'
        });
        $("#tnc-form").on("submit",function(){
            $("#hiddenArea").val($("#editor").html());
        })
    </script>
@endpush
